package com.kvaser.canlib;

import junit.framework.TestCase;
/**
 * Created by davidj on 2015-11-18.
 */
public class SynchronizedCircularBufferTest extends TestCase {

  public void testAddPop1() throws Exception {
    Byte b = 5;
    SynchronizedCircularBuffer buffer = new SynchronizedCircularBuffer(10, true);
    buffer.add(b);
    assertEquals("Wrong value popped." , b, buffer.pop());
    assertEquals("Buffer expected to be empty.", null, buffer.pop());
  }

  public void testWrapOnOverflow() throws Exception {
    Byte b = 5;
    SynchronizedCircularBuffer buffer = new SynchronizedCircularBuffer(4, true);
    for (int i = 0; i <= 5; i++)
    {
      buffer.add((byte)i);
    }
    for (int i = 2; i <= 5; i++)
    {
      assertEquals("Wrong value popped.", (byte) i, (byte) buffer.pop());
    }
    assertEquals("Buffer expected to be empty.", null, buffer.pop());
  }

  public void testNoWrapOnOverflow() throws Exception {
    Byte b = 5;
    SynchronizedCircularBuffer buffer = new SynchronizedCircularBuffer(4, false);
    for (int i = 0; i <= 5; i++)
    {
      buffer.add((byte)i);
    }
    for (int i = 0; i <= 3; i++)
    {
      assertEquals("Wrong value popped.", (byte) i, (byte) buffer.pop());
    }
    assertEquals("Buffer expected to be empty.", null, buffer.pop());
  }
}