#ifndef CL_TYPES_H
#define CL_TYPES_H

#ifdef __cplusplus
extern "C" {
#endif //__cplusplus

#include <stdint.h>
#include <stddef.h>

#ifdef __GNUC__
#include <sys/types.h>
#else
    #ifdef _MSC_VER
        #include <BaseTsd.h>
        typedef SSIZE_T ssize_t;
    #else
        #error "Figure out where ssize_t is on other platforms"
    #endif // _MSC_VER
#endif // __GNUC__

#include <cl/defines.h>

#ifndef BIT
#define BIT(n) (1UL << (n))
#endif

enum cl_status {
    // A-OK
    CL_STATUS_SUCCESS = 0,

    // Access
    CL_STATUS_OPERATION_NOT_PERMITTED = 10,
    CL_STATUS_OPERATION_FAILED = 11,
    CL_STATUS_OPERATION_NOT_SUPPORTED_BY_DEVICE = 12,
    CL_STATUS_OPERATION_NOT_SUPPORTED_BY_INTERFACE = 13,

    // Network
    CL_STATUS_TIMED_OUT = 100,
    CL_STATUS_NOT_CONNECTED = 101,
    CL_STATUS_UNKNOWN_NETWORK_ERROR = 102,
    CL_STATUS_UNABLE_TO_CONNECT = 103,
    CL_STATUS_UNABLE_TO_OPEN_SOCKET = 104,
    CL_STATUS_SOCKET_WRITE_ERROR = 105,
    CL_STATUS_SOCKET_READ_ERROR = 106,

    // Protocol
    CL_STATUS_NOT_IMPLEMENTED = 200,
    CL_STATUS_BUFFER_TOO_SMALL = 201,
    CL_STATUS_UNKNOWN_DEVICE = 202,
    CL_STATUS_UNKNOWN_INTERFACE = 203,
    CL_STATUS_PROTOCOL_ERROR = 204,
    CL_STATUS_PROTOCOL_CLIENT_OLDER_THAN_SERVICE = 205,
    CL_STATUS_INVALID_INTERFACE = 206,
    CL_STATUS_INVALID_USAGE = 207,
    CL_STATUS_INVALID_UTF8 = 208,

    // General
    CL_STATUS_EXCEEDING_STRING_LENGTH_LIMIT = 301,
    CL_STATUS_UNABLE_TO_ALLOCATE_MEMORY = 302,
    CL_STATUS_INVALID_ARGUMENT = 303,
    CL_STATUS_INVALID_COMBINATION = 304,

    // Generic
    CL_STATUS_UNSPECIFIED_ERROR = 1000,
    CL_STATUS_MAX = UINT16_MAX
};
typedef uint16_t cl_status_t;

enum cl_interface_type {
    CL_INTERFACE_T1 = 0,
    _CL_INTERFACE_RESERVED_1 = 1,
    CL_INTERFACE_T = 2,
};
typedef uint8_t cl_interface_type_t;

enum cl_eth_link_state {
    CL_ETH_LINK_STATE_DOWN,
    CL_ETH_LINK_STATE_UP,
};
typedef uint8_t cl_eth_link_state_t;

enum cl_eth_link_mode {
    CL_ETH_LINK_MODE_10MBIT = BIT(0),
    CL_ETH_LINK_MODE_100MBIT = BIT(1),
    CL_ETH_LINK_MODE_1000MBIT = BIT(2),

    // Bits 3-5 are reserved, but currently unused

    CL_ETH_LINK_MODE_DUPLEX_HALF = BIT(6),
    CL_ETH_LINK_MODE_DUPLEX_FULL = BIT(7),

    CL_ETH_LINK_MODE_FOLLOWER = BIT(8), // Slave in old terminology
    CL_ETH_LINK_MODE_LEADER = BIT(9), // Master in old terminology
    CL_ETH_LINK_MODE_ANEG = BIT(10),

    // Bits 11-13 are reserved, but currently unused
};
typedef uint16_t cl_eth_link_mode_t;

typedef uint16_t cl_id_type_t;
typedef cl_id_type_t cl_interface_id_t;
typedef cl_id_type_t cl_device_id_t;

typedef struct {
    cl_interface_type_t type;
    union {
        struct {
            cl_eth_link_state_t link_state;
            cl_eth_link_mode_t link_mode;

            union {
                struct {
                    uint8_t placeholder;
                } t;
                struct {
                    uint8_t placeholder;
                } t1;
                struct {
                    uint8_t placeholder;
                } t1s;
            } phy;
        } eth;

        struct {
            uint16_t bitrate;
            union {
                struct {
                    uint8_t placeholder;
                } classic;
                struct {
                    uint8_t placeholder;
                } fd;
                struct {
                    uint8_t placeholder;
                } xl;
            } version;
        } can;

        struct {
            uint8_t foo;
        } lin;
    } phy_interface;
} cl_interface_status_t;

#ifdef __cplusplus
}
#endif //__cplusplus

#endif // CL_TYPES_H
