#ifndef COMMON_CL_DEFINES_H
#define COMMON_CL_DEFINES_H

#ifdef __cplusplus
extern "C" {
#endif //__cplusplus

#if defined(__GNUC__)
    #define CL_CC

    #ifdef CL_BUILD_API
        #define CL_API __attribute__((visibility("default")))
    #else
        #define CL_API
    #endif // CL_BUILD_API
#elif defined(_WIN32)
    #define CL_CC __stdcall

    #if defined(CL_BUILD_API) && defined(CL_API_SHARED)
        #define CL_API __declspec(dllexport)
    #elif defined(CL_API_SHARED)
        #define CL_API __declspec(dllimport)
    #else
        #define CL_API
    #endif
#else
    #error "This platform is not yet supported!"
#endif

#ifdef __cplusplus
}
#endif //__cplusplus

#endif // COMMON_CL_DEFINES_H
