# Kvaser CAN Extcap

An [Extcap](https://www.wireshark.org/docs/wsdg_html_chunked/ChCaptureExtcap.html) for Wireshark made to capture CAN and CANFD packets in the PcapNG format on devices from Kvaser AB using it's CANlib.

## Prerequisites

To use the external capture program the Kvaser drivers needs to be installed, these can be found [here](https://kvaser.com/download/) for both Linux and Windows.

## Installation

To use the extcap with Wireshark, the executable needs to be placed in the `extcap` folder in the Wireshark directory. On Windows this is located at `C:\Program Files\Wireshark\extcap\wireshark` for version 4.4 (for older version it is `C:\Program Files\Wireshark\extcap`) if the default path was used during intallation and for Linux (Ubuntu) it might be `/usr/lib/x86_64-linux-gnu/wireshark/extcap/` or `/usr/local/lib/wireshark/extcap/`. After this is done Kvaser devices should appear in the list of interfaces in Wireshark (It might require a restart of Wireshark if it was open when placing the executable).

## Usage

User guides can be found under the *docs/userguides* folder.

### Standalone

The executable can also be used by itself. This just means that the capturing is made to a specified file (in the PcapNG format) that can then be read by Wireshark or used in any other way. More information can be found [here](https://www.wireshark.org/docs/man-pages/extcap.html).

Configuration is done by passing arguments to the executable and these can be found by using the `--help` or `-h` flag.

A CAN example with logging: .\kvaser_can_extcap.exe --capture --extcap-interface 0 --fifo C:\Users\\$USER$\extcap\test.pcapng  --pcapng_interface_info --bitrate -2 --log --log_level 4 --logfile C:\Users\\$USER$\extcap\logs\test.log

## Compile

### Dependencies

To build the extcap the [CANlib SDK](https://kvaser.com/download/) (installed on default path), [Meson](https://mesonbuild.com/Getting-meson.html) and [ninja](https://ninja-build.org/) is needed. There might be additional dependecies based on which operating system used, in that case they will be found below under either the Windows or Linux headers.

### Windows

Both MSVC and MSYS2 can be used to compile the extcap (for now, this might change).

For Windows the Microsoft [build tools](https://visualstudio.microsoft.com/downloads/?q=build+tools) are needed for the MSVC compiler, this is the recommened compiler to use.

Besides the build tools, MINGW64 from the [MSYS2](https://www.msys2.org/) tool collection can be used to compile. For this only the gcc compiler has been tested.

To compile the extcap the script build.bat can be used for MSVC. The usage of the script can be printed with the `--help` or `-h` flags. It is **IMPORTANT** that the script are run from the project root directory where the script is placed. The script have 4 different compile versions:

    - Debug
    - Release
    - Debug with optimizations
    - Minimal size

The script will create an executable called kvaser_can_extcap.exe under the created *build* directory. A *Release* version can be built using the command shown below, this requires the use of the `x64 Native Tools Command Prompt for VS`.

    .\build.bat release

A script, build-mingw.sh, also exist to compile for Windows with the MSYS2 tool collection. To do this the MSYS2 tool collection needs to be installed (along side the above dependecies) so that the `MINGW64` application can be used. Once that is done locate the git repository folder and execute the script as shown below.

    .\build-mingw.sh release

This will place the executable in the *build* directory, which can then be used as normal.

### Linux

To compile on Linux gcc has been used, clang might work but is has not been tested.

To compile the extcap the script build.sh can be used. The usage of the script can be printed with the `--help` or `-h` flags. The script have 4 different compile versions:

    - Debug
    - Release
    - Debug with optimizations
    - Minimal size

The scripts will create an executable called kvaser_can_extcap under the created *build* directory. A *Release* version can be built using the commands shown below.

    ./build.sh release

## Known issues

- No support for capturing from multiple interfaces at the same time. Wireshark supports it but the extcap does not.
- No support for non-ISO canFD.
- CTRL-C is not handled so shutdown is not handled gracefully.
- The time reported for each packet is not formated correctly.

## License

Kvaser CAN Extcap is distributed under the GNU GPLv2 license. Look at the LICENSE file to see the full license text.

If you have received a version of this software in binary form that gives you the right to receive the source code for this binary, to obtain a copy of the source code contact Kvaser AB support. This can be done via mail (<support@kvaser.com>) or via the webpage (<https://kvaser.com/support/>).

Your request should include:

- The name of the binary file for which you are requesting the source code (in this case: Kvaser CAN Extcap)
- The version number of the binary
- The date you received the product
- Your name
- Your company name (if applicable)
- The return email to which the source code should be sent

To retrive the version of the binary use the command ```--extcap-interfaces```, the version will be printed at the top.
