class BoundSignal(object):
    def __init__(self, signal, frame):
        self.frame = frame
        self.signal = signal

    def __repr__(self):
        txt = ("<{}: name={!r}, phys={!r}>".
               format(self.__class__.__name__, self.name, self.phys))
        if self.unit:
            txt += ", unit:{}".format(self.unit)
        return txt

    @property
    def phys(self):
        """Return signal's physical value."""
        value = self.signal.phys_from(self.frame.data)
        return value

    @phys.setter
    def phys(self, value):
        """Adjust CAN data according to physical value."""
        self.frame.data = self.signal.data_from(self.frame.data, phys=value)

    @property
    def raw(self):
        """Return signal's raw value."""
        value = self.signal.raw_from(self.frame.data)
        return value

    @raw.setter
    def raw(self, value):
        """Adjust CAN data according to raw value."""
        self.frame.data = self.signal.data_from(self.frame.data, raw=value)

    @property
    def unit(self):
        """Return signal's unit string."""
        return self.signal.unit

    @property
    def name(self):
        """Return signal's name string"""
        return self.signal.name
