
try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup


def readme():
    with open('README.rst') as f:
        return f.read()


def get_version():
    version = {}
    with open("canlib/version.py") as fp:
        exec(fp.read(), version)
    print("version: %s" % version['__version__'])
    return version['__version__']

setup(
    name='canlib',
    version=get_version(),
    description='Python wrapper for Kvaser CANlib',
    long_description=readme(),
    url='https://github.com/Kvaser/python-canlib',
    author='Kvaser AB',
    author_email='support@kvaser.com',
    license='MIT',
    # See https://pypi.python.org/pypi?%3Aaction=list_classifiers
    classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: Developers',
        'Topic :: Software Development',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3.4',
    ],
    keywords='development',
    packages=['canlib'],
    test_suite='nose.collector',
    tests_require=['nose'],
    )
