from . import enums

# Most of these constants are deprecated, use the enum mentioned instead. (Or
# whatever is after the '=', even if its not an enum.)

canOK = 0
canERR_PARAM = enums.Error.PARAM
canERR_NOMSG = enums.Error.NOMSG
canERR_NOTFOUND = enums.Error.NOTFOUND
canERR_NOCHANNELS = enums.Error.NOCHANNELS
canERR_TIMEOUT = enums.Error.TIMEOUT
canERR_INVHANDLE = enums.Error.INVHANDLE
canERR_TXBUFOFL = enums.Error.TXBUFOFL
canERR_NOCARD = enums.Error.NOCARD
canERR_SCRIPT_FAIL = enums.Error.SCRIPT_FAIL
canERR_NOT_IMPLEMENTED = enums.Error.NOT_IMPLEMENTED

canOPEN_EXCLUSIVE = enums.Open.EXCLUSIVE
canOPEN_REQUIRE_EXTENDED = enums.Open.REQUIRE_EXTENDED
canOPEN_ACCEPT_VIRTUAL = enums.Open.ACCEPT_VIRTUAL
canOPEN_OVERRIDE_EXCLUSIVE = enums.Open.OVERRIDE_EXCLUSIVE
canOPEN_REQUIRE_INIT_ACCESS = enums.Open.REQUIRE_INIT_ACCESS
canOPEN_NO_INIT_ACCESS = enums.Open.NO_INIT_ACCESS
canOPEN_ACCEPT_LARGE_DLC = enums.Open.ACCEPT_LARGE_DLC
canOPEN_CAN_FD = enums.Open.CAN_FD
canOPEN_CAN_FD_NONISO = enums.Open.CAN_FD_NONISO

# canBITRATE_xxx
canBITRATE_1M = enums.Bitrate.BITRATE_1M
canBITRATE_500K = enums.Bitrate.BITRATE_500K
canBITRATE_250K = enums.Bitrate.BITRATE_250K
canBITRATE_125K = enums.Bitrate.BITRATE_125K
canBITRATE_100K = enums.Bitrate.BITRATE_100K
canBITRATE_62K = enums.Bitrate.BITRATE_62K
canBITRATE_50K = enums.Bitrate.BITRATE_50K
canBITRATE_83K = enums.Bitrate.BITRATE_83K
canBITRATE_10K = enums.Bitrate.BITRATE_10K
# canFD_BITRATE_xxx
canFD_BITRATE_500K_80P = enums.BitrateFD.BITRATE_500K_80P
canFD_BITRATE_1M_80P = enums.BitrateFD.BITRATE_1M_80P
canFD_BITRATE_2M_80P = enums.BitrateFD.BITRATE_2M_80P
canFD_BITRATE_4M_80P = enums.BitrateFD.BITRATE_4M_80P
canFD_BITRATE_8M_60P = enums.BitrateFD.BITRATE_8M_60P
canFD_BITRATE_8M_80P = enums.BitrateFD.BITRATE_8M_80P

canIOCTL_PREFER_EXT = enums.IOControlItem.PREFER_EXT
canIOCTL_PREFER_STD = enums.IOControlItem.PREFER_STD
canIOCTL_CLEAR_ERROR_COUNTERS = enums.IOControlItem.CLEAR_ERROR_COUNTERS
canIOCTL_SET_TIMER_SCALE = enums.IOControlItem.SET_TIMER_SCALE
canIOCTL_SET_TXACK = enums.IOControlItem.SET_TXACK
canIOCTL_GET_RX_BUFFER_LEVEL = enums.IOControlItem.GET_RX_BUFFER_LEVEL
canIOCTL_GET_TX_BUFFER_LEVEL = enums.IOControlItem.GET_TX_BUFFER_LEVEL
canIOCTL_FLUSH_RX_BUFFER = enums.IOControlItem.FLUSH_RX_BUFFER
canIOCTL_FLUSH_TX_BUFFER = enums.IOControlItem.FLUSH_TX_BUFFER
canIOCTL_GET_TIMER_SCALE = enums.IOControlItem.GET_TIMER_SCALE
canIOCTL_SET_TXRQ = enums.IOControlItem.SET_TXRQ
canIOCTL_GET_EVENTHANDLE = enums.IOControlItem.GET_EVENTHANDLE
canIOCTL_SET_BYPASS_MODE = enums.IOControlItem.SET_BYPASS_MODE
canIOCTL_SET_WAKEUP = enums.IOControlItem.SET_WAKEUP
canIOCTL_MAP_RXQUEUE = enums.IOControlItem.MAP_RXQUEUE
canIOCTL_GET_WAKEUP = enums.IOControlItem.GET_WAKEUP
canIOCTL_SET_REPORT_ACCESS_ERRORS = enums.IOControlItem.SET_REPORT_ACCESS_ERRORS
canIOCTL_GET_REPORT_ACCESS_ERRORS = enums.IOControlItem.GET_REPORT_ACCESS_ERRORS
canIOCTL_CONNECT_TO_VIRTUAL_BUS = enums.IOControlItem.CONNECT_TO_VIRTUAL_BUS
canIOCTL_DISCONNECT_FROM_VIRTUAL_BUS = enums.IOControlItem.DISCONNECT_FROM_VIRTUAL_BUS
canIOCTL_SET_USER_IOPORT = enums.IOControlItem.SET_USER_IOPORT
canIOCTL_GET_USER_IOPORT = enums.IOControlItem.GET_USER_IOPORT
canIOCTL_SET_BUFFER_WRAPAROUND_MODE = enums.IOControlItem.SET_BUFFER_WRAPAROUND_MODE
canIOCTL_SET_RX_QUEUE_SIZE = enums.IOControlItem.SET_RX_QUEUE_SIZE
canIOCTL_SET_USB_THROTTLE = enums.IOControlItem.SET_USB_THROTTLE
canIOCTL_GET_USB_THROTTLE = enums.IOControlItem.GET_USB_THROTTLE
canIOCTL_SET_BUSON_TIME_AUTO_RESET = enums.IOControlItem.SET_BUSON_TIME_AUTO_RESET
canIOCTL_GET_TXACK = enums.IOControlItem.GET_TXACK
canIOCTL_SET_LOCAL_TXECHO = enums.IOControlItem.SET_LOCAL_TXECHO
canIOCTL_SET_ERROR_FRAMES_REPORTING = enums.IOControlItem.SET_ERROR_FRAMES_REPORTING
canIOCTL_GET_CHANNEL_QUALITY = enums.IOControlItem.GET_CHANNEL_QUALITY
canIOCTL_GET_ROUNDTRIP_TIME = enums.IOControlItem.GET_ROUNDTRIP_TIME
canIOCTL_GET_BUS_TYPE = enums.IOControlItem.GET_BUS_TYPE
canIOCTL_GET_DEVNAME_ASCII = enums.IOControlItem.GET_DEVNAME_ASCII
canIOCTL_GET_TIME_SINCE_LAST_SEEN = enums.IOControlItem.GET_TIME_SINCE_LAST_SEEN
canIOCTL_GET_TREF_LIST = enums.IOControlItem.GET_TREF_LIST
canIOCTL_TX_INTERVAL = enums.IOControlItem.TX_INTERVAL
canIOCTL_SET_THROTTLE_SCALED = enums.IOControlItem.SET_THROTTLE_SCALED
canIOCTL_GET_THROTTLE_SCALED = enums.IOControlItem.GET_THROTTLE_SCALED
canIOCTL_SET_BRLIMIT = enums.IOControlItem.SET_BRLIMIT
canIOCTL_RESET_OVERRUN_COUNT = enums.IOControlItem.RESET_OVERRUN_COUNT
canIOCTL_LIN_MODE = enums.IOControlItem.LIN_MODE
canIOCTL_SET_LOCAL_TXACK = enums.IOControlItem.SET_LOCAL_TXACK

canCHANNELDATA_CHANNEL_CAP = enums.ChannelDataItem.CHANNEL_CAP
canCHANNELDATA_TRANS_CAP = enums.ChannelDataItem.TRANS_CAP
canCHANNELDATA_CHANNEL_FLAGS = enums.ChannelDataItem.CHANNEL_FLAGS
canCHANNELDATA_CARD_TYPE = enums.ChannelDataItem.CARD_TYPE
canCHANNELDATA_CARD_NUMBER = enums.ChannelDataItem.CARD_NUMBER
canCHANNELDATA_CHAN_NO_ON_CARD = enums.ChannelDataItem.CHAN_NO_ON_CARD
canCHANNELDATA_CARD_SERIAL_NO = enums.ChannelDataItem.CARD_SERIAL_NO
canCHANNELDATA_TRANS_SERIAL_NO = enums.ChannelDataItem.TRANS_SERIAL_NO
canCHANNELDATA_CARD_FIRMWARE_REV = enums.ChannelDataItem.CARD_FIRMWARE_REV
canCHANNELDATA_CARD_HARDWARE_REV = enums.ChannelDataItem.CARD_HARDWARE_REV
canCHANNELDATA_CARD_UPC_NO = enums.ChannelDataItem.CARD_UPC_NO
canCHANNELDATA_TRANS_UPC_NO = enums.ChannelDataItem.TRANS_UPC_NO
canCHANNELDATA_CHANNEL_NAME = enums.ChannelDataItem.CHANNEL_NAME
canCHANNELDATA_DLL_FILE_VERSION = enums.ChannelDataItem.DLL_FILE_VERSION
canCHANNELDATA_DLL_PRODUCT_VERSION = enums.ChannelDataItem.DLL_PRODUCT_VERSION
canCHANNELDATA_DLL_FILETYPE = enums.ChannelDataItem.DLL_FILETYPE
canCHANNELDATA_TRANS_TYPE = enums.ChannelDataItem.TRANS_TYPE
canCHANNELDATA_DEVICE_PHYSICAL_POSITION = enums.ChannelDataItem.DEVICE_PHYSICAL_POSITION
canCHANNELDATA_UI_NUMBER = enums.ChannelDataItem.UI_NUMBER
canCHANNELDATA_TIMESYNC_ENABLED = enums.ChannelDataItem.TIMESYNC_ENABLED
canCHANNELDATA_DRIVER_FILE_VERSION = enums.ChannelDataItem.DRIVER_FILE_VERSION
canCHANNELDATA_DRIVER_PRODUCT_VERSION = enums.ChannelDataItem.DRIVER_PRODUCT_VERSION
canCHANNELDATA_MFGNAME_UNICODE = enums.ChannelDataItem.MFGNAME_UNICODE
canCHANNELDATA_MFGNAME_ASCII = enums.ChannelDataItem.MFGNAME_ASCII
canCHANNELDATA_DEVDESCR_UNICODE = enums.ChannelDataItem.DEVDESCR_UNICODE
canCHANNELDATA_DEVDESCR_ASCII = enums.ChannelDataItem.DEVDESCR_ASCII
canCHANNELDATA_DRIVER_NAME = enums.ChannelDataItem.DRIVER_NAME
canCHANNELDATA_CHANNEL_QUALITY = enums.ChannelDataItem.CHANNEL_QUALITY
canCHANNELDATA_ROUNDTRIP_TIME = enums.ChannelDataItem.ROUNDTRIP_TIME
canCHANNELDATA_BUS_TYPE = enums.ChannelDataItem.BUS_TYPE
canCHANNELDATA_DEVNAME_ASCII = enums.ChannelDataItem.DEVNAME_ASCII
canCHANNELDATA_TIME_SINCE_LAST_SEEN = enums.ChannelDataItem.TIME_SINCE_LAST_SEEN
canCHANNELDATA_REMOTE_OPERATIONAL_MODE = enums.ChannelDataItem.REMOTE_OPERATIONAL_MODE
canCHANNELDATA_REMOTE_PROFILE_NAME = enums.ChannelDataItem.REMOTE_PROFILE_NAME
canCHANNELDATA_REMOTE_HOST_NAME = enums.ChannelDataItem.REMOTE_HOST_NAME
canCHANNELDATA_REMOTE_MAC = enums.ChannelDataItem.REMOTE_MAC
canCHANNELDATA_MAX_BITRATE = enums.ChannelDataItem.MAX_BITRATE
canCHANNELDATA_CHANNEL_CAP_MASK = enums.ChannelDataItem.CHANNEL_CAP_MASK
canCHANNELDATA_CUST_CHANNEL_NAME = enums.ChannelDataItem.CUST_CHANNEL_NAME
canCHANNELDATA_IS_REMOTE = enums.ChannelDataItem.IS_REMOTE
canCHANNELDATA_REMOTE_TYPE = enums.ChannelDataItem.REMOTE_TYPE
canCHANNELDATA_LOGGER_TYPE = enums.ChannelDataItem.LOGGER_TYPE
canCHANNELDATA_HW_STATUS = enums.ChannelDataItem.HW_STATUS
canCHANNELDATA_FEATURE_EAN = enums.ChannelDataItem.FEATURE_EAN

canMSG_MASK = enums.MessageFlag.MSG_MASK
canMSG_RTR = enums.MessageFlag.RTR
canMSG_STD = enums.MessageFlag.STD
canMSG_EXT = enums.MessageFlag.EXT
canMSG_WAKEUP = enums.MessageFlag.WAKEUP
canMSG_NERR = enums.MessageFlag.NERR
canMSG_ERROR_FRAME = enums.MessageFlag.ERROR_FRAME
canMSG_TXACK = enums.MessageFlag.TXACK
canMSG_TXRQ = enums.MessageFlag.TXRQ
canMSG_LOCAL_TXACK = enums.MessageFlag.LOCAL_TXACK

canFDMSG_MASK = enums.MessageFlag.FDMSG_MASK
canFDMSG_EDL = enums.MessageFlag.EDL
canFDMSG_FDF = enums.MessageFlag.FDF
canFDMSG_BRS = enums.MessageFlag.BRS
canFDMSG_ESI = enums.MessageFlag.ESI

canMSGERR_MASK = enums.MessageFlag.MSGERR_MASK
canMSGERR_HW_OVERRUN = enums.MessageFlag.HW_OVERRUN
canMSGERR_SW_OVERRUN = enums.MessageFlag.SW_OVERRUN
canMSGERR_STUFF = enums.MessageFlag.STUFF
canMSGERR_FORM = enums.MessageFlag.FORM
canMSGERR_CRC = enums.MessageFlag.CRC
canMSGERR_BIT0 = enums.MessageFlag.BIT0
canMSGERR_BIT1 = enums.MessageFlag.BIT1
canMSGERR_BIT = enums.MessageFlag.BIT
canMSGERR_BUSERR = enums.MessageFlag.BUSERR

canDRIVER_NORMAL = enums.Driver.NORMAL
canDRIVER_SILENT = enums.Driver.SILENT
canDRIVER_SELFRECEPTION = enums.Driver.SELFRECEPTION
canDRIVER_OFF = enums.Driver.OFF

# Haven't decided how to use this yet
kvEVENT_TYPE_KEY = 1

kvSCRIPT_STOP_NORMAL = enums.ScriptStop.NORMAL
kvSCRIPT_STOP_FORCED = enums.ScriptStop.FORCED

kvDEVICE_MODE_INTERFACE = enums.DeviceMode.INTERFACE
kvDEVICE_MODE_LOGGER = enums.DeviceMode.LOGGER

# Haven't decided how to use this yet
ENVVAR_MAX_SIZE = 4096

kvENVVAR_TYPE_INT = enums.EnvVarType.INT
kvENVVAR_TYPE_FLOAT = enums.EnvVarType.FLOAT
kvENVVAR_TYPE_STRING = enums.EnvVarType.STRING

canFILTER_SET_CODE_STD = enums.AcceptFilterFlag.SET_CODE_STD
canFILTER_SET_MASK_STD = enums.AcceptFilterFlag.SET_MASK_STD
canFILTER_SET_CODE_EXT = enums.AcceptFilterFlag.SET_CODE_EXT
canFILTER_SET_MASK_EXT = enums.AcceptFilterFlag.SET_MASK_EXT
canFILTER_NULL_MASK = enums.AcceptFilterFlag.NULL_MASK

kvLED_ACTION_ALL_LEDS_ON = enums.LEDAction.ALL_LEDS_ON
kvLED_ACTION_ALL_LEDS_OFF = enums.LEDAction.ALL_LEDS_OFF
kvLED_ACTION_LED_0_ON = enums.LEDAction.LED_0_ON
kvLED_ACTION_LED_0_OFF = enums.LEDAction.LED_0_OFF
kvLED_ACTION_LED_1_ON = enums.LEDAction.LED_1_ON
kvLED_ACTION_LED_1_OFF = enums.LEDAction.LED_1_OFF
kvLED_ACTION_LED_2_ON = enums.LEDAction.LED_2_ON
kvLED_ACTION_LED_2_OFF = enums.LEDAction.LED_2_OFF
kvLED_ACTION_LED_3_ON = enums.LEDAction.LED_3_ON
kvLED_ACTION_LED_3_OFF = enums.LEDAction.LED_3_OFF


canSTAT_ERROR_PASSIVE = enums.Stat.ERROR_PASSIVE
canSTAT_BUS_OFF = enums.Stat.BUS_OFF
canSTAT_ERROR_WARNING = enums.Stat.ERROR_WARNING
canSTAT_ERROR_ACTIVE = enums.Stat.ERROR_ACTIVE
canSTAT_TX_PENDING = enums.Stat.TX_PENDING
canSTAT_RX_PENDING = enums.Stat.RX_PENDING
canSTAT_RESERVED_1 = enums.Stat.RESERVED_1
canSTAT_TXERR = enums.Stat.TXERR
canSTAT_RXERR = enums.Stat.RXERR
canSTAT_HW_OVERRUN = enums.Stat.HW_OVERRUN
canSTAT_SW_OVERRUN = enums.Stat.SW_OVERRUN
